/*------------------------------------------------------------------------------*
 * File Name: import_const.h													*
 * Creation: January 28, 2004													*
 * Purpose: constants used during the import of data and images					*
 * Copyright (c) OriginLab Corp. 2004											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/

#ifndef _IMPORT_CONST_H
#define _IMPORT_CONST_H


#define IMPORT_FILE_INFO			"ImportFileInfo"
#define IMPORT_FILE_INFO_NAME		"FileName"
#define IMPORT_FILE_INFO_PATH		"FilePath"
#define IMPORT_FILE_INFO_DATE		"FileDate"
#define IMPORT_FILE_INFO_HEIGHT		"Height"
#define IMPORT_FILE_INFO_WIDTH		"Width"
#define IMPORT_FILE_INFO_BITS		"BitsPerPixel"
#define IMPORT_FILE_ENUM			"File"

/**#
	return  number of objects of specified type	
*/
int matrix_layer_get_num_objects(MatrixLayer& ml, int nType, TreeNode& tr);
/**#
*/
bool matrix_layer_get_import_info(MatrixLayer& ml, TreeNode &trn, int index = -1);


#pragma dll(OIMG60)

/** >Image
		Load an image into a buffer
	Paramaters:
		lpcszFile = pointer to an image file name
		data = pointer to a matrix buffer
		nDataSize = size of a single buffer element
		nRows = number of rows in the matrix
		nCols = number of columns in the matrix
	Returns:
		TRUE for success, FALSE for error
	Example:
*/
BOOL WINAPI oimg_load_image(LPCSTR lpcszFile, LPVOID data, int nDataSize, int nRows, int nCols);

/** >Image
		Get information about an image
	Paramaters:
		lpcszFile = pointer to an image file name
		nWidth = variable to receive the width of the image
		nHeight = variable to receive the height of the image
		nBitsPerPixel = variable to receive the number of bits per pixel in the image
	Returns:
		TRUE for success, FALSE for error
	Example:
*/
BOOL WINAPI oimg_image_info(LPCSTR lpcszFile, int *pnWidth, int *pnHeight, int *pnBitsPerPixel);

#endif // _IMPORT_CONST_H
